/* SIT 371 ASS2 Alessio Bonti 600230055 
 * 9/05/07
 */ 
import java.net.*;
import java.io.*;
import java.util.*;
import java.util.Vector;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.event.*;




public class SpellCheckClientChild extends JFrame implements ActionListener, ListSelectionListener
{
        
	JButton Replace;
	JButton Ignore;
	JButton Exit;
	JTextArea text ;
    JLabel label;
    JList list; 
    DefaultListModel listModel=new DefaultListModel();
    JPanel panelBottom;
	StringTokenizer st ;
    JScrollPane scroller;
    int i=0; // value used as the start index of a word of the textarea
    int b=0; // value used as the end index of a word in  the textarea
    String s; // used for tokenization and various labels
    Vector input; // used to transfer data from the server into the list
    String replacer; // used to replace a word in the text area
    int selection;  // used to select a word in the list
    JTextArea area; // is a reference to the textarea in the main client
    JLabel title=new JLabel("SPELLCHECKER");


	public SpellCheckClientChild(JTextArea t) //receives a txt area from the client
	{
                super("I am the spell checking assistant");
                list=new JList();
                list.setVisibleRowCount(3); // 3 rows made visible
                list.setAutoscrolls(true);
              	text = new JTextArea(t.getText()); // the local text area is filled with the data from the main client
                area=t; // area is referenced
               
                st=new StringTokenizer(text.getText()); // divides words into tokens
                s = st.nextToken(); // next token 
		
                Container container;
				setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
				container = getContentPane();
				container.setLayout(new BorderLayout());
                
		        Replace = new JButton("Replace");
				Replace.addActionListener(this);
		
                Ignore = new JButton("Ignore");
                Ignore.addActionListener(this);
		
                Exit = new JButton("Exit");
				Exit.addActionListener(this);
		
                JPanel panelLeft = new JPanel();
                JPanel panelBottom = new JPanel();
				JPanel panelRight = new JPanel();
                JPanel panelTop=new JPanel();
                
                panelRight.setLayout(new GridLayout(3,1));  
                panelLeft.setLayout(new GridLayout(3,1)); 
                panelBottom.setLayout(new GridLayout(1,1));
				panelLeft.setBackground(Color.LIGHT_GRAY);
				panelBottom.setBackground(Color.BLUE);
                panelTop.setBackground(Color.WHITE);
                label=new JLabel(s);
                label.setForeground(Color.RED);
		
                panelLeft.add(Replace);
                panelLeft.add(Ignore);
                panelLeft.add(Exit);
                panelRight.add(label);
                panelTop.add(text);
             
                	
               	container.add(panelTop, BorderLayout.NORTH);
                container.add(panelLeft,BorderLayout.WEST);
				container.add(panelBottom, BorderLayout.SOUTH);
				container.add(panelRight, BorderLayout.EAST);
                 
                doReplacement(s); // calls the doReplacement function when the child is called
                list=new JList(listModel); // list is referenced to a listModel to make it dynamic
                list.setSelectedIndex(0);
                list.setSize(40,10);
                list.setVisibleRowCount(4);
                
                scroller=new JScrollPane(list);
                scroller.setSize(20,50);
                panelBottom.add(scroller);   
                panelRight.add(title);
                
                list.addListSelectionListener(this); // listener is added for changes
                           
                                
				setSize(300, 250);
		
				setVisible(true);
                
                
                
	}
        
        

        /* doReplacement
         *This method isused to do a spellcheck on the words and it fills up the list
         *also, it makes the replace button invisible if the word is correct
         */
        public DefaultListModel doReplacement(String s)
        {
        
				 int z=0;    
            
                 spellcheck(s);
                
            
                for(z=0;z<input.size();z++)
                listModel.addElement(input.elementAt(z));
              
                list.setSelectedIndex(0);
               
                if(listModel.isEmpty()==true)
                {title.setText("Correct word");
                    Replace.setEnabled(false);}
                else
                {
                    title.setText("Wrong word");
                    this.Replace.setEnabled(true);
                }
                return listModel; // updates the list 
        }
        
        
         /*This method is used to listen for changes in the list , the change is used to replace a word
          * in the text area with one present in the list
          */
        
        public void valueChanged(ListSelectionEvent e)
		{
		selection=list.getSelectedIndex();
            
             
        }
        
        
        
        
        
        /*This listener listens for changes events connected to the buttons.
         *
         *
         *
         */
        
	public void actionPerformed(ActionEvent e)
	{
		String a;
                
                /*When the Replace button is clicked,it replaces the corresponding word
                 * in the textarea with the one selected by using various indexes.
                 *
                 */
		if (e.getSource() == Replace)
                {
               
                b = this.i + s.length() - 1;         
               	                 
				text.replaceRange("", i, b+1);                          
                replacer=(String)input.elementAt(selection); // replacer is taken from the list
                listModel.removeAllElements(); // the list is cleared
                text.insert(replacer, i);   // the word selected is inserted into the text area
		
                i = this.b+replacer.length() + 2-s.length();
                if(st.hasMoreTokens()) // if there are more tokens available, then the list fill operation is done again
                    {
                     s = st.nextToken();
                     this.label.setText(s);
                     doReplacement(s);
                    }
                    else // if there are no more tokens, buttons are disabled
                    {
                    Replace.setEnabled(false);
                    Ignore.setEnabled(false);
                     this.title.setText("COMPLETE");
                    }                                            
                }
                
                
                // in case user wants to ignore a word
                
                else if (e.getSource() == Ignore)
		{   
                        listModel.removeAllElements(); //list is cleared
                         if(st.hasMoreTokens()) // checks if there are more tokens
                         {
                            /*indexes are kept update since the word is skipped
                             *
                             */
                            b = this.i + s.length()-1;
                            i = this.b + 2; 
                            s = st.nextToken();
                            this.label.setText(s);
                            doReplacement(s); 
                                                       
                         }
                         else
                         {
                       
                        Ignore.setEnabled(false);
                        Replace.setEnabled(false);
                        this.title.setText("COMPLETE");
                        }        
                         
		}    
                
                
                
                
                
                
		else if (e.getSource() == Exit)
		{
                    area.setText(text.getText()); // text in the main client updated
                    this.dispose(); // window is closed
			
		}
	}
        
        
       
        
        
        /* this method is the one that handles the message passing between the server and the client
         * the parsed word (token) is sent to the server to be checked and a vector is returned.
         *
         */
        
        public  void spellcheck(String word)
	{			
		String output = word; // string to be sent to the server
               
		try{
		
			Socket socket=new Socket("127.0.0.1", 9999); // socket to the server
			ObjectOutputStream clientOutputStream = new ObjectOutputStream(socket.getOutputStream());// OOS to send out data
			ObjectInputStream clientInputStream = new ObjectInputStream(socket.getInputStream()); // IOS to receive data
			clientOutputStream.writeObject(output); // sends the string to server
			input = (Vector)clientInputStream.readObject(); // the vector is filled with data from the server
                       			
                        socket.close(); // closes the socket
               
			
			
		
		}
		catch(IOException e){}
		catch (ClassNotFoundException e) { }
		catch (IllegalArgumentException e) {}
               
		
	}

}
