
/**
 *  This class is the main class of the "World of Zuul" application. 
 *  "World of Zuul" is a very simple, text based adventure game.  Users 
 *  can walk around some scenery. That's all. It should really be extended 
 *  to make it more interesting!
 * 
 *  To play this game, create an instance of this class and call the "play"
 *  method.
 * 
 *  This main class creates and initialises all the others: it creates all
 *  rooms, creates the parser and starts the game.  It also evaluates and
 *  executes the commands that the parser returns.
 * 
 * @author  Michael Kolling and David J. Barnes
 * @version 1.0 (February 2002)
 */


class Game 
{
    private Parser parser;
    private Room currentRoom;
    private Room lastRoom;
        
      
    /**
     * Create the game and initialise its internal map.
     */
        
    public Game() 
    {
        createRooms();
        parser = new Parser();
    }

    /**
     * MAIN
     */
    
    public static void main(String [] arg)
    {
        Game game = new Game();
        game.play();
    }
    
    /**
     * Create all the rooms and link their exits together.
     */
    private void createRooms()
    {
        Room casa, lab, ufficio, macchinette, cesso, cantina;

        // create the rooms
        casa = new Room("at home sitten on a chair");
        lab = new Room("the laboratory");
        ufficio = new Room("the office");
        macchinette = new Room("caff machine");
        cesso = new Room("the bathroom");
        cantina = new Room("it's deem and dark, you're in the cellars");

        
        // initialise room exits and item
        casa.setExits("south", lab);
        casa.setItems("Un vaso", 300);
        casa.setItems("Un pallone", 350);
        casa.setItems("Un Tavolo", 45000);
        casa.setItems("Una sedia", 2500);
        
        
        lab.setExits("north", casa);
        lab.setExits("south", ufficio);
        lab.setExits("down", cantina);

        ufficio.setExits("north", lab);
        ufficio.setExits("south", macchinette);
        
        macchinette.setExits("north", ufficio);
        macchinette.setExits("east", cesso);

        cesso.setExits("north", casa);
        cesso.setExits("west", macchinette);
        cesso.setItems("carta igienica", 50);
        cesso.setItems("water", 50000);
        
        cantina.setExits("up", lab);
        cantina.setItems("Una bottiglia di vino", 1000);

   
        currentRoom = casa;  // start game outside
        lastRoom = casa;      
        
    }

    /**
     *  Main play routine.  Loops until end of play.
     */
    public void play() 
    {            
        printWelcome();

        // Enter the main command loop.  Here we repeatedly read commands and
        // execute them until the game is over.
                
        boolean finished = false;
        while (! finished) {
            Command command = parser.getCommand();
            finished = processCommand(command);
        }
        System.out.println("Thank you for playing.  Good bye.");
    }

    /**
     * Print out the opening message for the player.
     */
    private void printWelcome()
    {
        System.out.println();
        System.out.println("Welcome to Adventure!");
        System.out.println("Adventure is a new, incredibly boring adventure game.");
        System.out.println("Type 'help' if you need help.");
        System.out.println();
        System.out.println(currentRoom.getLongDescription());
    }

    /**
     * Given a command, process (that is: execute) the command.
     * If this command ends the game, true is returned, otherwise false is
     * returned.
     */
    private boolean processCommand(Command command) 
    {
        boolean wantToQuit = false;

        if(command.isUnknown()) {
            System.out.println("I don't know what you mean...");
            return false;
        }

        String commandWord = command.getCommandWord();
        if (commandWord.equals("help"))
            printHelp(parser.showCommands());
        else if (commandWord.equals("go"))
            goRoom(command);
        else if (commandWord.equals("look"))
            look();
        else if (commandWord.equals("eat"))
            eat();
        else if (commandWord.equals("back"))
            back();
        else if (commandWord.equals("quit"))
            wantToQuit = quit(command);

        return wantToQuit;
    }

    // implementations of user commands:

    /**
     * Print out some help information.
     * Here we print some stupid, cryptic message and a list of the 
     * command words.
     */
    private void printHelp(String commandsAvaliable) 
    {
        System.out.println("You are lost. You are alone.");
        System.out.println("You wander around your home.");
        System.out.println();
        System.out.println("Your command words are:");
        System.out.println(commandsAvaliable);
    }

    /** 
     * Try to go to one direction. If there is an exit, enter
     * the new room, otherwise print an error message.
     */
    private void goRoom(Command command) 
    {
        if(!command.hasSecondWord()) {
            // if there is no second word, we don't know where to go...
            System.out.println("Go where?");
            return;
        }

        String direction = command.getSecondWord();

        // Try to leave current room.
        Room nextRoom = null;
        nextRoom = currentRoom.getExit(direction);

        if (nextRoom == null)
            System.out.println("There is no door!");
        else {
            lastRoom = currentRoom;
            currentRoom = nextRoom;
            System.out.println(currentRoom.getExitString());
        }
    }

    /** 
     * "Quit" was entered. Check the rest of the command to see
     * whether we really quit the game. Return true, if this command
     * quits the game, false otherwise.
     */
    private boolean quit(Command command) 
    {
        if(command.hasSecondWord()) {
            System.out.println("Quit what?");
            return false;
        }
        else
            return true;  // signal that we want to quit
    }

    /**
     * Restituisce cosa si vede intorno
     */
    private void look()
    {
        System.out.println(currentRoom.getLongDescription());
    }
    
    private void back()
    {
        Room tempRoom = currentRoom;
        currentRoom = lastRoom;
        lastRoom = tempRoom;
        System.out.println(currentRoom.getLongDescription());
    }
    
    /**
     * Fa mangiare l'npg
     */
    
    private void eat()
    {
        System.out.println("You've eaten, now you're no more hungry");
    }
}


