import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

/*
 * Class Room - a room in an adventure game.
 *
 * This class is the main class of the "World of Zuul" application. 
 * "World of Zuul" is a very simple, text based adventure game.  
 *
 * A "Room" represents one location in the scenery of the game.  It is 
 * connected to other rooms via exits.  The exits are labelled north, 
 * east, south, west.  For each direction, the room stores a reference
 * to the neighboring room, or null if there is no exit in that direction.
 * 
 * @author  Michael Kolling and David J. Barnes
 * @version 1.0 (February 2002)
 */

class Room 
{
    private String description;
    private HashMap exits;
    private HashMap items;

    /**
     * Create a room described "description". Initially, it has
     * no exits and no item in it. 
     * "description" is something like "a kitchen" or
     * "an open court yard".
     */
    public Room(String description) 
    {
        this.description = description;
        exits = new HashMap();
        items = new HashMap();
    }

    /**
     * Definisce un'uscita da questa stanza.
     */

    public void setExits (String direction, Room neighbor)
    {
        exits.put(direction, neighbor);
    }
    
    /**
     * Restituisce la stanza che si raggiunge muovendosi nella 
     * direzione "direction". Se non ci sono stanza in quella 
     * direzione, restituisce null
     */
    public Room getExit(String direction)
    {
        return (Room)exits.get(direction);
    }
    
    public String getExitString()
    {
        String returnString = "Exits:";
        Set keys = exits.keySet();
        for (Iterator iter = keys.iterator(); iter.hasNext();)
        {
            returnString += " " + iter.next();
        }
        return returnString;
    }

    /**
     * Definisce gli oggetti contenuti nella stanza
     * passa l'oggetto e il suo peso
     */
    public void setItems (String description, int weight)
    {
        items.put(description, weight);
    }
    
    public String getItemString()
    {
        String outString = "Items:";
        Set objects = items.keySet();
        for (Iterator it = objects.iterator(); it.hasNext(); )
        {
            outString += " " +it.next();
        }
        return outString;    
    }    
    
    /**
     * Return the description of the room (the one that was defined
     * in the constructor).
     */
    private String getDescription()
    {
        return description;
    }

    /**
     * Restituisce una descrizione lunga, nella forma:
     * You are in the Room
     * Exits: north west
     */
    public String getLongDescription()
    {
        return  "You are in " + description + ".\n"
            +   getExitString() + ".\n" 
            +   getItemString();
    }
        
}
